﻿using System;
using System.Data;
using System.Linq;
using System.Web;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

public partial class Default : BasePage
{
    private UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;

    protected void Page_Load(object sender, EventArgs e)
    {
        string settings = Helpers.GetCrsSetting("EFRShowDefaultLandingPage");

        if (settings.ToLower() != "true")
        {
            RedirectBasedOnUserRole();
        }

        if (!IsPostBack)
        {
            DataTable dataTable = SqlProvider.ExecuteSPDataTable(
                "RegistryConnectionString", "GetEfrCountStatistics");

            gvCountStatistics.DataSource = dataTable;
            gvCountStatistics.DataBind();

            gvCountStatistics.Caption = "";
        }
    }
    public override string TopMenuName()
    {
        return "My Tasks";
    }
    public override string MenuItemName()
    {
        return "";
    }
    public override string AppObjectCode()
    {
        return "EFR DEFAULT";
    }

    /// <summary>
    /// This function sets Redirects based on the user role.
    /// </summary>
    private void RedirectBasedOnUserRole()
    {

        if (_user.GetRoles().Contains((int)RoleCode.EFR_TEFSC_COORDINATOR)
            || _user.GetRoles().Contains((int)RoleCode.EFR_TEFSC_NURSE))
        {
            Response.Redirect("EventReminders.aspx");
        }
        else if (_user.GetRoles().Contains((int)RoleCode.EFR_TEFSC_PROVIDER))
        {
            Response.Redirect("Patients.aspx");

        }

        //if ( _user.GetRoles().Contains((int)RoleCode.EFR_TEFSC_COORDINATOR)
        //    || _user.GetRoles().Contains((int)RoleCode.EFR_TEFSC_NURSE)
        //    || _user.GetRoles().Contains((int)RoleCode.EFR_TEFSC_PROVIDER))
        //{
        //    Response.Redirect("Patients.aspx");
        //}



        else if (_user.GetRoles().Contains((int)RoleCode.EFR_TEFSC_ADMINISTRATOR))
        {
            Response.Redirect("LabOrders.aspx?statusId=6");
        }
        else if (_user.GetRoles().Contains((int)RoleCode.EFR_DATA_ENTRY_PERSONNEL))
        {
            Response.Redirect("Surveys.aspx?statusId=6");
        }
    }
    protected void OnContinueClick(object sender, EventArgs e)
    {
        RedirectBasedOnUserRole();
    }
}
